/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.client.state;

import java.util.List;

import com.vaadin.shared.ui.orderedlayout.VerticalLayoutState;

public class QueryState
    extends VerticalLayoutState
{

    private static final long serialVersionUID = 6542530547468212312L;

    private int initProgress = -1;

    private List<Integer> invisibleHeaderRows = null;

    private List<String> joinedTables = null;

    /**
     * Get initialization progress.
     * 
     * @return initialization progress
     */
    public int getInitProgress()
    {
        return initProgress;
    }

    /**
     * Set initialization progress.
     * 
     * @param initProgress
     *            initialization progress
     */
    public void setInitProgress( int initProgress )
    {
        this.initProgress = initProgress;
    }

    /**
     * Get invisible header rows.
     * 
     * @return invisible header rows
     */
    public List<Integer> getInvisibleHeaderRows()
    {
        return invisibleHeaderRows;
    }

    /**
     * Set invisible header rows.
     * 
     * @param invisibleHeaderRows
     *            invisible header rows
     */
    public void setInvisibleHeaderRows( List<Integer> invisibleHeaderRows )
    {
        this.invisibleHeaderRows = invisibleHeaderRows;
    }

    /**
     * Get joined tables.
     * 
     * @return joined tables
     */
    public List<String> getJoinedTables()
    {
        return joinedTables;
    }

    /**
     * Set joined tables.
     * 
     * @param joinedTables
     *            joined tables
     */
    public void setJoinedTables( List<String> joinedTables )
    {
        this.joinedTables = joinedTables;
    }

}
