/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.ui.windows;

import org.dussan.vaadin.dquery.base.ui.BaseWindow;
import org.dussan.vaadin.dquery.base.ui.DroppedTable;

import com.vaadin.ui.Button.ClickEvent;
import com.vaadin.ui.Button.ClickListener;
import com.vaadin.ui.Label;
import com.vaadin.ui.themes.ValoTheme;

public abstract class MessageWindow
    extends BaseWindow
{

    private static final long serialVersionUID = 898081685219372589L;

    public static final String CLEAR_TABLE_CONTAINER_AND_FIELD_COLUMNS =
        "Do you want to clear table container and field columns?";

    public static final String QUERY_DELETE = "Do you want to delete query: {0}/{1}";

    public static final String QUERY_VIEW = "Do you want to " + DroppedTable.BUTTON_QUERY.toLowerCase() + "?";

    public static final String WARNING = "Warning";

    /**
     * Creates a new instance.
     */
    private MessageWindow()
    {
        setSizeUndefined();
        getOkButton().setEnabled( true );
        getCancelButton().setEnabled( true );
    }

    /**
     * Creates a new instance.
     * 
     * @param caption
     *            window caption
     * @param message
     *            message
     */
    public MessageWindow( String caption, String message )
    {
        this();
        setCaption( caption );

        Label label = new Label( message );
        label.addStyleName( ValoTheme.LABEL_SMALL );
        addContextComponent( label );

        // "OK" button click
        getOkButton().addClickListener( new ClickListener()
        {
            private static final long serialVersionUID = -3052133491000926713L;

            @Override
            public void buttonClick( ClickEvent event )
            {
                onOkClick();

                // close dialog window
                close();
            }
        } );
    }

    /**
     * Abstract function for click event for button "OK".
     */
    public abstract void onOkClick();

}
