/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.events;

import java.util.Map;

import org.dussan.vaadin.dquery.json.JsonQuery;

import com.google.gwt.event.shared.GwtEvent;

public class QueryChangeEvent
    extends GwtEvent<QueryChangeHandler>
{

    public static final Type<QueryChangeHandler> TYPE = new Type<>();

    private JsonQuery currentQuery = null;

    private Map<String, Map<String, JsonQuery>> queries = null;

    public QueryChangeEvent( Map<String, Map<String, JsonQuery>> queries, JsonQuery currentQuery )
    {
        this.queries = queries;
        this.currentQuery = currentQuery;
    }

    public JsonQuery getCurrentQuery()
    {
        return currentQuery;
    }

    public Map<String, Map<String, JsonQuery>> getQueries()
    {
        return queries;
    }

    @Override
    public Type<QueryChangeHandler> getAssociatedType()
    {
        return TYPE;
    }

    @Override
    protected void dispatch( QueryChangeHandler handler )
    {
        handler.onQueryChange( this );
    }

    public static Type<QueryChangeHandler> getType()
    {
        return TYPE;
    }

}
