/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.enums;

/**
 * SQL drivers.
 */
public enum SqlDriver
{

    DERBY( "org.apache.derby.jdbc.ClientDriver", "jdbc:derby:" ),
    DERBY_EMBEDDED( "org.apache.derby.jdbc.EmbeddedDriver", "jdbc:derby:" ),
    H2( "org.h2.Driver", "jdbc:h2:" ),
    HSQLDB( "org.hsqldb.jdbcDriver", "jdbc:hsqldb:" ),
    MYSQL( "com.mysql.jdbc.Driver", "jdbc:mysql:" ),
    OFFLINE_MODE( "offline.mode", "offline.mode" ),
    POSTGRESQL( "org.postgresql.Driver", "jdbc:postgresql:" ),
    SQLITE( "org.sqlite.JDBC", "jdbc:sqlite:" );

    private final String driver;

    private String urlController;

    /**
     * Create a new instance.
     * 
     * @param driver
     *            sql driver
     */
    private SqlDriver( String driver, String urlController )
    {
        this.driver = driver;
        this.urlController = urlController;
    }

    public boolean isPassingUrlControl( String url )
    {
        return url.startsWith( urlController );
    }

    /**
     * Get sql driver string.
     */
    @Override
    public String toString()
    {
        return driver;
    }

}
