/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.enums;

/**
 * Query elements.
 */
public enum QueryElements
{
    DATA_SOURCE_ID( "datasource_id" ),
    GROUP( "group" ),
    NAME( "name" ),
    FIELDS( "fields" ),
    JOINS( "joins" ),
    QUERY( "query" ),
    QUERY_AS_COLUMN( "query_as_column" ),
    TABLES( "tables" );

    private String element;

    /**
     * Create a new instance.
     * 
     * @param element
     *            query element
     */
    private QueryElements( String element )
    {
        this.element = element;
    }

    /**
     * @return query element as string
     */
    @Override
    public String toString()
    {
        return element;
    }

    /**
     * Query's element: join
     */
    public enum Join
    {

        FROM( "from" ), FROM_FIELDS( "from_fields" ), TO( "to" ), TO_FIELDS( "to_fields" ), TYPE( "type" );

        private String joinObject;

        private Join( String join )
        {
            joinObject = join;
        }

        /**
         * @return table query's join element as string
         */
        @Override
        public String toString()
        {
            return joinObject;
        }

    }

    /**
     * Query's element: field
     */
    public enum Field
    {

        COLUMN( "column" ),
        COMMON( "common" ),
        FIELD( "field" ),
        NAME( "name" ),
        SHOW( "show" ),
        SORTING( "sorting" ),
        TABLE( "table" ),
        TOTAL( "total" ),
        UNDEFINED( "undefined" );

        private String fieldObject;

        private Field( String field )
        {
            fieldObject = field;
        }

        /**
         * Retrieve field from string value.
         * 
         * @param field
         *            value from which retrieve field
         * @return field
         */
        public static Field get( Object field )
        {
            for ( Field value : Field.values() )
            {
                if ( value.toString()
                          .equalsIgnoreCase( field.toString() ) )
                {
                    return value;
                }
            }

            // not found
            return UNDEFINED;
        }

        /**
         * Get query's field element as upper case string.
         * 
         * @return query's field element as upper case string
         */
        public String toUpperCaseString()
        {
            return fieldObject.toUpperCase();
        }

        /**
         * @return query's field element as string
         */
        @Override
        public String toString()
        {
            return fieldObject;
        }

    }

    /**
     * Query's element: table
     */
    public enum Table
    {

        ALIAS( "alias" ),
        DATA_SOURCE_ID( "datasource_id" ),
        DATABASE( "database" ),
        NAME( "name" ),
        POSITION( "position" ),
        TYPE( "type" );

        private String tableObject;

        /**
         * Create a new instance.
         * 
         * @param table
         *            query's table element
         */
        private Table( String table )
        {
            tableObject = table;
        }

        /**
         * @return query's table element as string
         */
        @Override
        public String toString()
        {
            return tableObject;
        }

        /**
         * Table query's element: position
         */
        public enum Position
        {

            LEFT( "left" ), TOP( "top" );

            private String positionObject;

            /**
             * Create a new instance.
             * 
             * @param position
             *            query's table element
             */
            private Position( String position )
            {
                positionObject = position;
            }

            /**
             * @return table query's position element as string
             */
            @Override
            public String toString()
            {
                return positionObject;
            }

        }

    }

}
