/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.test;

import javax.servlet.annotation.WebServlet;

import org.dussan.vaadin.dquery.DQuery;
import org.dussan.vaadin.dquery.enums.SqlDriver;
import org.dussan.vaadin.dquery.events.GroupQueryChangeEvent;
import org.dussan.vaadin.dquery.events.GroupQueryChangeHandler;
import org.dussan.vaadin.dquery.events.QueryChangeEvent;
import org.dussan.vaadin.dquery.events.QueryChangeHandler;
import org.dussan.vaadin.dquery.utils.JdbcUtil;

import com.vaadin.annotations.Theme;
import com.vaadin.annotations.VaadinServletConfiguration;
import com.vaadin.annotations.Widgetset;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinServlet;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;

@Theme( "dquery-theme" )
@Widgetset( "org.dussan.vaadin.dquery.WidgetSet" )
public class DQueryUI
    extends UI
{

    private static final long serialVersionUID = 5696542465716721125L;

    private static final String CATALOG = "database";

    private static final String[] COLUMNS = { "column1", "column2", "column3", "column4", "column5" };

    private static final String DATASOURCE_1 = "test1";

    private static final String DATASOURCE_2 = "test2";

    private static final String DATASOURCE_3 = "offline";

    private static final String DESCRIPITON_1 = "Data for testing";

    private static final String DESCRIPITON_2 = "Testing data";

    private static final String DESCRIPITON_3 = "Offline data";

    private static final String DESCRIPTION_TEST = "Description test";

    // private static final String QUERY_EVENT = "Query event";

    // private static final String QUERY_EVENT_DATA = "Query data change";

    // private static final String QUERY_EVENT_GROUP = "Group query data change";

    private static final String PASSWORD = "test";

    private static final SqlDriver SQL_DRIVER = SqlDriver.MYSQL;

    private static final String TABLE_1 = "table1";

    private static final String TABLE_2 = "table2";

    private static final String TABLE_3 = "table3";

    private static final String TABLE_4 = "table4";

    private static final String TABLE_DEMO = "dept_emp";

    private static final String URL = "jdbc:mysql://datacenter:3306/test";

    private static final String USER = "test";

    private DQuery query = null;

    public DQueryUI()
    {
        query = new DQuery();
        query.setCriteriaPageLength( 3 );
        query.setFieldColumns( 20 );
        query.setFieldColumnWidth( 150 );
        query.setSaveChangesEnabled( true );
    }

    @Override
    protected void init( VaadinRequest request )
    {
        query.addDataSource( DATASOURCE_1, new JdbcUtil().setDescription( DESCRIPITON_1 )
                                                         .setDriver( SQL_DRIVER )
                                                         .setUrl( URL )
                                                         .setUser( USER )
                                                         .setPassword( PASSWORD ) );

        query.addDataSource( DATASOURCE_2, new JdbcUtil().setDescription( DESCRIPITON_2 )
                                                         .setDriver( SQL_DRIVER )
                                                         .setUrl( URL )
                                                         .setUser( USER )
                                                         .setPassword( PASSWORD ) );

        // offline mode demo
        query.addDataSource( DATASOURCE_3, new JdbcUtil().setDescription( DESCRIPITON_3 )
                                                         .setCatalog( CATALOG )
                                                         .addTable( TABLE_1, COLUMNS )
                                                         .addTable( TABLE_2, COLUMNS )
                                                         .addTable( TABLE_3, COLUMNS )
                                                         .addTable( TABLE_4, COLUMNS ) );

        query.setDataSourcesItemVisible( true );
        // query.setCreateNewQueryGroupEnabled( false );
        // query.setDataSourceEnabled( DATASOURCE_2, false );
        // query.setDataSourceTableDisabled( DATASOURCE_1, "dept_emp", true );
        query.setDataSourceTableDisabled( DATASOURCE_2, TABLE_DEMO, true );
        query.setTableDescription( DATASOURCE_1, TABLE_DEMO, DESCRIPTION_TEST );
        query.setShowDroppedTableDataEnabled( DATASOURCE_1, false );

        VerticalLayout content = new VerticalLayout();
        content.setSizeFull();
        content.addComponent( query );
        setContent( content );

        query.addHandler( new QueryChangeHandler()
        {
            @Override
            public void onQueryChange( QueryChangeEvent event )
            {
                // query.removeDataSource( DATASOURCE_2 );
                // new Notification( QUERY_EVENT, QUERY_EVENT_DATA, Type.ERROR_MESSAGE, true ).show( Page.getCurrent()
                // );
            }
        } );

        query.addHandler( new GroupQueryChangeHandler()
        {
            @Override
            public void onGroupQueryChange( GroupQueryChangeEvent event )
            {
                // new Notification( QUERY_EVENT, QUERY_EVENT_GROUP, Type.ERROR_MESSAGE, true ).show( Page.getCurrent()
                // );
            }
        } );
    }

    @WebServlet( urlPatterns = "/*", name = "DQueryUIServlet", asyncSupported = true )
    @VaadinServletConfiguration( ui = DQueryUI.class, productionMode = false )
    public static class DQueryUIServlet
        extends VaadinServlet
    {

        private static final long serialVersionUID = 8594659431268563118L;

    }

}
