/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.events;

import com.google.gwt.event.shared.GwtEvent;
import com.vaadin.event.Transferable;

public class TableContainerDropEvent
    extends GwtEvent<TableContainerDropHandler>
{

    public static final Type<TableContainerDropHandler> TYPE = new Type<>();

    private int left = 0;

    private int top = 0;

    private Transferable transferableObject = null;

    public TableContainerDropEvent( int left, int top, Transferable transferableObject )
    {
        this.left = left;
        this.top = top;
        this.transferableObject = transferableObject;
    }

    public int getLeft()
    {
        return left;
    }

    public int getTop()
    {
        return top;
    }

    public Transferable getTransferableObject()
    {
        return transferableObject;
    }

    @Override
    public Type<TableContainerDropHandler> getAssociatedType()
    {
        return TYPE;
    }

    @Override
    protected void dispatch( TableContainerDropHandler handler )
    {
        handler.onDrop( this );
    }

    public static Type<TableContainerDropHandler> getType()
    {
        return TYPE;
    }

}
