/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.component;

import java.util.LinkedHashMap;
import java.util.Map;

import org.dussan.vaadin.dquery.client.state.QueryState;
import org.dussan.vaadin.dquery.helper.ManifestHelper;
import org.dussan.vaadin.dquery.json.JsonBuilder;
import org.dussan.vaadin.dquery.sql.builder.SqlBuilder;
import org.dussan.vaadin.dquery.ui.DataSourcesMenu;
import org.dussan.vaadin.dquery.ui.DroppedTableContainer;
import org.dussan.vaadin.dquery.ui.SqlMenu;
import org.dussan.vaadin.dquery.ui.SqlTabs;
import org.dussan.vaadin.dquery.utils.JdbcUtil;
import org.dussan.vaadin.dquery.utils.SharedUtil;

import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.ui.VerticalLayout;

public class DQueryComponent
    extends VerticalLayout
{

    private static final long serialVersionUID = 8504642832573585503L;

    private static final String DQUERY = "dquery";

    private static final String GIT_VERSION = "Git-Version";

    private static final String VERSION = "Implementation-Version";

    protected static final String CONTENT = "content";

    protected static final String DATASOURCE_MENU = "datasource-menu";

    protected static final String DATASOURCES_ALREADY_HAVE_THIS_IDENTIFIER =
        "Data sources already have this identifier: {0}.";

    protected static final String DATASOURCES_DOES_NOT_HAVE_THIS_IDENTIFIER =
        "Data sources does not have this identifier: {0}.";

    protected static final String FIELDS = "fields";

    protected static final String IDENTIFIER_IS_EMPTY = "Identifier is empty.";

    protected static final String SQL_MENU = "sql-menu";

    protected static final String TABLES = "tables";

    private transient Map<String, JdbcUtil> dataSources = null;

    private DataSourcesMenu dataSourcesMenu = null;

    private DroppedTableContainer droppedTableContainer = null;

    private JsonBuilder jsonBuilder = null;

    private SqlBuilder sqlBuilder = null;

    private SqlMenu sqlMenu = null;

    private SqlTabs sqlTabs = null;

    /**
     * Creates a new instance.
     */
    public DQueryComponent()
    {
        setMargin( false );
        setSpacing( false );
        setSizeFull();
        setHeightUndefined();
        addStyleName( DQUERY );

        // data sources
        dataSources = new LinkedHashMap<>();

        // data sources menu
        dataSourcesMenu = new DataSourcesMenu();
        dataSourcesMenu.setCenteredTabs( true );
        dataSourcesMenu.setFloatingMenuLockEnabled( true );

        // container for dropped tables
        droppedTableContainer = new DroppedTableContainer();

        // json builder
        jsonBuilder = new JsonBuilder();

        // sql menu
        sqlMenu = new SqlMenu();

        // sql tabs
        sqlTabs = new SqlTabs();
        sqlTabs.setCenteredTabs( true );
    }

    /**
     * Setting margins is disabled.
     */
    @Override
    public void setMargin( boolean enabled )
    {
        super.setMargin( false );
    }

    /**
     * Setting margins is disabled.
     */
    @Override
    public void setMargin( MarginInfo marginInfo )
    {
        super.setMargin( new MarginInfo( false ) );
    }
    
    /**
     * Get dQuery version.
     * 
     * @return dQuery version
     */
    public static String getVersion()
    {
        if ( !SharedUtil.isNull( ManifestHelper.getManifest() ) )
        {
            return ManifestHelper.getManifest()
                                 .getMainAttributes()
                                 .getValue( VERSION );
        }
        return null;
    }

    /**
     * Get dQuery git version.
     * 
     * @return dQuery git version
     */
    public static String getGitVersion()
    {
        if ( !SharedUtil.isNull( ManifestHelper.getManifest() ) )
        {
            return ManifestHelper.getManifest()
                                 .getMainAttributes()
                                 .getValue( GIT_VERSION );
        }
        return null;
    }

    /**
     * Get the shared state.
     */
    @Override
    protected QueryState getState()
    {
        return (QueryState) super.getState();
    }

    /**
     * Get the shared state.
     */
    @Override
    protected QueryState getState( boolean markAsDirty )
    {
        return (QueryState) super.getState( markAsDirty );
    }

    /**
     * Get data sources.
     * 
     * @return data sources
     */
    protected Map<String, JdbcUtil> getDataSources()
    {
        return dataSources;
    }

    /**
     * Get data sources menu.
     * 
     * @return data sources menu
     */
    protected DataSourcesMenu getDataSourcesMenu()
    {
        return dataSourcesMenu;
    }

    /**
     * Get container for dropped tables.
     * 
     * @return container for dropped tables
     */
    protected DroppedTableContainer getDroppedTableContainer()
    {
        return droppedTableContainer;
    }

    /**
     * Get Json builder.
     * 
     * @return Json builder
     */
    protected JsonBuilder getJsonBuilder()
    {
        return jsonBuilder;
    }

    /**
     * Get Sql builder.
     * 
     * @return Sql builder
     */
    protected SqlBuilder getSqlBuilder()
    {
        return sqlBuilder;
    }

    /**
     * Reset Sql builder.
     */
    protected void resetSqlBuilder()
    {
        sqlBuilder = new SqlBuilder();
    }

    /**
     * Get Sql menu.
     * 
     * @return Sql menu
     */
    protected SqlMenu getSqlMenu()
    {
        return sqlMenu;
    }

    /**
     * Get Sql tabs.
     * 
     * @return Sql tabs
     */
    protected SqlTabs getSqlTabs()
    {
        return sqlTabs;
    }

}
