/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.utils;

import java.io.Serializable;

public class SharedUtil
    implements Serializable
{

    private static final long serialVersionUID = 937947770423184349L;

    public static final Object[] EMPTY_OBJECT_ARRAY = {};

    /**
     * Creates a new instance.
     */
    private SharedUtil()
    {
        // Auto-generated constructor stub
    }

    /**
     * Check if object is null.
     * 
     * @param value
     *            object value
     * @return true if object is null; false otherwise
     */
    public static boolean isNull( Object value )
    {
        return value == null;
    }

    /**
     * Check if object is not null.
     * 
     * @param value
     *            object value
     * @return true if object is not null; false otherwise
     */
    public static boolean isNotNull( Object value )
    {
        return !isNull( value );
    }

    /**
     * Check if string is null or empty.
     * 
     * @param value
     *            string value
     * @return true if string is null or empty; false otherwise
     */
    public static boolean isNullOrEmpty( Object value )
    {
        if ( isNotNull( value ) )
        {
            return value.toString()
                        .isEmpty();
        }
        return true;
    }

    /**
     * Check if string is not null and not empty.
     * 
     * @param value
     *            string value
     * @return true if string is not null and not empty; false otherwise
     */
    public static boolean isNotNullAndNotEmpty( Object value )
    {
        return !isNullOrEmpty( value );
    }

    /**
     * Check if string represent integer value.
     * 
     * @param value
     *            string value
     * @return true if string represent integer value; false otherwise
     */
    public static boolean isInteger( Object value )
    {
        return isNotNullAndNotEmpty( value ) && value.toString()
                                                     .matches( "^[+-]?\\d+$" );
    }

}
