/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.base.ui;

import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.ui.Button;
import com.vaadin.ui.Button.ClickEvent;
import com.vaadin.ui.Button.ClickListener;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import com.vaadin.ui.themes.ValoTheme;

public abstract class BaseWindow
    extends Window
{

    private static final long serialVersionUID = -3679543606821257638L;

    private static final String BUTTON_CANCEL = "Cancel";

    private static final String BUTTON_OK = "OK";

    private static final String MODAL = "modal";

    private static final String MODAL_BUTTONS = MODAL + "-buttons";

    private Button okButton = null;

    private Button cancelButton = null;

    private HorizontalLayout buttonLayout = null;

    private VerticalLayout context = null;

    /**
     * Creates a new instance.
     */
    public BaseWindow()
    {
        setWidth( 60, Unit.PERCENTAGE );
        setClosable( false );
        setResizable( false );
        setModal( true );
        center();
        addStyleName( MODAL );

        // window content
        VerticalLayout content = new VerticalLayout();
        content.setMargin( true );
        content.setSpacing( false );
        setContent( content );

        // window context
        context = new VerticalLayout();
        context.setMargin( new MarginInfo( false, false, true, false ) );
        context.setSpacing( true );
        content.addComponent( context );

        // "OK" button
        okButton = new Button( BUTTON_OK );
        okButton.setEnabled( false );
        okButton.addStyleName( ValoTheme.BUTTON_SMALL );

        // "Cancel" button
        cancelButton = new Button( BUTTON_CANCEL );
        cancelButton.addStyleName( ValoTheme.BUTTON_SMALL );

        // buttons layout
        buttonLayout = new HorizontalLayout( okButton, cancelButton );
        buttonLayout.setWidthUndefined();
        buttonLayout.setMargin( false );
        buttonLayout.setSpacing( true );
        buttonLayout.addStyleName( MODAL_BUTTONS );
        content.addComponent( buttonLayout );

        // "Cancel" button click
        cancelButton.addClickListener( new ClickListener()
        {
            private static final long serialVersionUID = 5329565533594945156L;

            @Override
            public void buttonClick( ClickEvent event )
            {
                // close dialog window
                close();
            }
        } );
    }

    /**
     * Get "OK" button.
     * 
     * @return "OK" button
     */
    public Button getOkButton()
    {
        return okButton;
    }

    /**
     * Get "Cancel" button.
     * 
     * @return "Cancel" button
     */
    public Button getCancelButton()
    {
        return cancelButton;
    }

    /**
     * Get context.
     * 
     * @return context
     */
    public VerticalLayout getContext()
    {
        return context;
    }

    /**
     * Add new component to context.
     */
    public void addContextComponent( Component component )
    {
        context.addComponent( component );
    }
}
