/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.client.connector;

import org.dussan.vaadin.dquery.DQuery;
import org.dussan.vaadin.dquery.client.VDQuery;
import org.dussan.vaadin.dquery.client.events.QueryEvents;
import org.dussan.vaadin.dquery.client.rpc.QueryServerRpc;
import org.dussan.vaadin.dquery.client.state.QueryState;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.vaadin.client.communication.RpcProxy;
import com.vaadin.client.communication.StateChangeEvent;
import com.vaadin.client.ui.SimpleManagedLayout;
import com.vaadin.client.ui.orderedlayout.VerticalLayoutConnector;
import com.vaadin.shared.ui.Connect;

@Connect( DQuery.class )
public class QueryConnector
    extends VerticalLayoutConnector
    implements SimpleManagedLayout, ValueChangeHandler<Object[]>
{

    private static final long serialVersionUID = 6203598505780171122L;

    private QueryServerRpc serverRpc = null;

    public QueryConnector()
    {
        serverRpc = RpcProxy.create( QueryServerRpc.class, this );
    }

    @Override
    public void init()
    {
        super.init();
        getWidget().addValueChangeHandler( this );
    }

    @Override
    public QueryState getState()
    {
        return (QueryState) super.getState();
    }

    @Override
    public VDQuery getWidget()
    {
        return (VDQuery) super.getWidget();
    }

    @Override
    public void onStateChanged( StateChangeEvent stateChangeEvent )
    {
        super.onStateChanged( stateChangeEvent );
        getWidget().setInvisibleHeaderRows( getState().getInvisibleHeaderRows() );
        getWidget().setJoinedTables( getState().getJoinedTables() );
        getWidget().refreshHeaderRows();
        getWidget().redrawJoinedTablesLines();
        getWidget().processingInitProgress( getState().getInitProgress() );
    }

    @Override
    public void layout()
    {
        if ( getState().getInitProgress() == 100 )
        {
            getWidget().prepare();
            getWidget().refreshHeaderRows();
            getWidget().redrawJoinedTablesLines();
            getWidget().processingInitProgress( getState().getInitProgress() );
        }
    }

    @Override
    public void onValueChange( ValueChangeEvent<Object[]> event )
    {
        switch ( (Integer) event.getValue()[0] )
        {
            case QueryEvents.CHANGE_JOINED_TABLES:
                serverRpc.changeJoinedTables( (String) event.getValue()[1], (Integer) event.getValue()[2] );
                break;
            case QueryEvents.INIT_PROGRESS:
                serverRpc.initProgress( (Integer) event.getValue()[1] );
                break;
            case QueryEvents.TABLE_MOVED:
                serverRpc.tableMoved( (String) event.getValue()[1], (Integer) event.getValue()[2],
                                      (Integer) event.getValue()[3] );
                break;
            default:
                break;
        }
    }

}
