/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.enums;

/**
 * Table types.
 */
public enum TableType
{

    TABLE( "table" ), QUERY( "query" );

    private final String type;

    private TableType( String type )
    {
        this.type = type;
    }

    public static TableType getType( String type )
    {
        for ( TableType value : TableType.values() )
        {
            if ( value.type.equals( type.trim() ) )
            {
                return value;
            }
        }
        return null;
    }

    @Override
    public String toString()
    {
        return type;
    }

}
