/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.utils;

import java.io.Serializable;

import com.vaadin.server.Page;
import com.vaadin.shared.Position;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Notification.Type;

public class ErrorUtil
    implements Serializable
{

    private static final long serialVersionUID = 3439499766458968401L;

    private static final String ERROR = "ERROR";

    public static final String CANNOT_ADD_NEW_COLUMN =
        "Cannot add a new column, because all available columns already have a value.";

    public static final String CANNOT_ADD_QUERY_BECAUSE_IT_IS_ALREADY_CREATED =
        "Cannot add query because it is already created with that group and name.";

    public static final String CANNOT_ADD_QUERY_BECAUSE_SQL_DRIVER_IS_NOT_DEFINED =
        "Cannot add query because Sql driver is not defined.";

    public static final String CANNOT_ADD_QUERY_TO_ITSELF = "Cannot add query to itself query definition.";

    public static final String CANNOT_CONNECT_TO_DATABASE = "Cannot connect to database: {0}";

    public static final String CANNOT_CONNECT_TO_DATABASE_IN_OFFLINE_MODE =
        "Cannot connect to database in offline mode.";

    public static final String CANNOT_FIND_DATASOURCE_FOR_DATABASE = "Cannot find data source for database \"{0}\".";

    public static final String CANNOT_RUN_QUERY = "Cannot run query because cannot find any available data source.";

    public static final String CANNOT_SAVE_QUERY = "Cannot save query because it include itself query definition.";

    public static final String CANNOT_SAVE_QUERY_BECAUSE_IT_IS_ALREADY_CREATED =
        "Cannot save query because it is already created with that group and name.";

    public static final String JSON_QUERY_IMPORT = "Error in imported json query: {0}";

    private Notification notification = null;

    /**
     * Creates a new instance.
     */
    private ErrorUtil()
    {
        notification = new Notification( ERROR, Type.ERROR_MESSAGE );
        notification.setPosition( Position.TOP_CENTER );
    }

    /**
     * Creates a new instance with error type.
     * 
     * @param type
     *            error message type
     */
    public ErrorUtil( String type )
    {
        this();
        notification.setDescription( type );
    }

    /**
     * Show error message.
     */
    public void show()
    {
        notification.show( Page.getCurrent() );
    }

}
