/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.enums;

/**
 * Json query elements.
 */
public enum JsonQueryElement
{
    DATA_SOURCE_ID( "datasource_id" ),
    GROUP( "group" ),
    NAME( "name" ),
    FIELDS( "fields" ),
    JOINS( "joins" ),
    QUERY( "query" ),
    QUERY_AS_COLUMN( "query_as_column" ),
    TABLES( "tables" );

    private String queryElement;

    /**
     * Create a new instance.
     * 
     * @param queryElement
     *            json query element
     */
    private JsonQueryElement( String queryElement )
    {
        this.queryElement = queryElement;
    }

    /**
     * @return json query element as string
     */
    @Override
    public String toString()
    {
        return queryElement;
    }

}
