/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dtabs.test;

import javax.servlet.annotation.WebServlet;

import org.dussan.vaadin.dtabs.DTabs;
import org.dussan.vaadin.dtabs.DTabsProperty;

import com.vaadin.annotations.Theme;
import com.vaadin.annotations.VaadinServletConfiguration;
import com.vaadin.annotations.Widgetset;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinServlet;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;

@Theme( "dtabs-theme" )
@Widgetset( "org.dussan.vaadin.dtabs.WidgetSet" )
public class DTabsUI
    extends UI
{

    private static final long serialVersionUID = -4455057907563375941L;

    @Override
    protected void init( VaadinRequest vaadinRequest )
    {
        final VerticalLayout layout = new VerticalLayout();
        layout.setMargin( true );
        layout.setSpacing( true );
        setContent( layout );

        DTabs tabs = new DTabs();
        tabs.setProperties( DTabsProperty.BOTTOM_TABBAR, DTabsProperty.CENTERED_TABS, DTabsProperty.COMPACTED_TABBAR,
                            DTabsProperty.FRAMED_TABS );
        layout.addComponent( tabs );

        VerticalLayout tab1 = new VerticalLayout();
        tab1.setCaption( "TAB1" );
        tab1.addComponent( new Label( "tab1" ) );
        tab1.setMargin( true );
        tabs.addTab( tab1 );

        VerticalLayout tab2 = new VerticalLayout();
        tab2.setCaption( "TAB2" );
        tab2.addComponent( new Label( "tab2" ) );
        tab2.addComponent( new Label( "tab2" ) );
        tab2.setMargin( true );
        tabs.addTab( tab2 );

        VerticalLayout tab3 = new VerticalLayout();
        tab3.setCaption( "TAB3" );
        tab3.addComponent( new Label( "tab3" ) );
        tab3.setMargin( true );
        tabs.addTab( tab3 );

        VerticalLayout tab4 = new VerticalLayout();
        tab4.setCaption( "TAB4" );
        tab4.addComponent( new Label( "tab4" ) );
        tab4.addComponent( new Label( "tab4" ) );
        tab4.addComponent( new Label( "tab4" ) );
        tab4.setMargin( true );
        tabs.addTab( tab4 );

        for ( int index = 0; index < tabs.getComponentCount(); index++ )
        {
            tabs.getTab( index )
                .setClosable( true );
            tabs.getTab( index )
                .setIcon( FontAwesome.AMBULANCE );
        }
    }

    @WebServlet( urlPatterns = "/*", name = "DTabsUIServlet", asyncSupported = true )
    @VaadinServletConfiguration( ui = DTabsUI.class, productionMode = true )
    public static class DTabsUIServlet
        extends VaadinServlet
    {

        private static final long serialVersionUID = 8594659431268563118L;

    }

}
