/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dtabs;

import com.vaadin.ui.themes.ValoTheme;

public enum DTabsProperty
{

    BOTTOM_TABBAR( "bottom-tabbar" ),
    CENTERED_TABS( ValoTheme.TABSHEET_CENTERED_TABS ),
    COMPACTED_TABBAR( ValoTheme.TABSHEET_COMPACT_TABBAR ),
    EQUAL_WIDTH_TABS( ValoTheme.TABSHEET_EQUAL_WIDTH_TABS ),
    FRAMED_TABS( ValoTheme.TABSHEET_FRAMED ),
    ICONS_ON_TOP( ValoTheme.TABSHEET_ICONS_ON_TOP ),
    ONLY_SELECTED_TAB_IS_CLOSABLE( ValoTheme.TABSHEET_ONLY_SELECTED_TAB_IS_CLOSABLE ),
    RIGHT_ALIGNED_TABS( "right-aligned-tabs" ),
    PADDED_TABBAR( ValoTheme.TABSHEET_PADDED_TABBAR );

    private final String property;

    private DTabsProperty( String property )
    {
        this.property = property;
    }

    @Override
    public String toString()
    {
        return this.property;
    }

}
