/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dtabs.client;

import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.DOM;
import com.vaadin.client.ui.VTabsheet;

public class TabsWidget
    extends VTabsheet
{

    private static final String CONTENT = "v-tabsheet-content";

    private static final String TAB_CONTAINER = "v-tabsheet-tabcontainer";

    private boolean tabBarIsBottom = false;

    public TabsWidget()
    {
        // Auto-generated method stub
    }

    public boolean isTabBarBottom()
    {
        return tabBarIsBottom;
    }

    public void setTabBarBottom( boolean tabBarIsBottom )
    {
        if ( this.tabBarIsBottom != tabBarIsBottom )
        {
            int contentIndex = -1;
            int tabContainerIndex = -1;
            this.tabBarIsBottom = tabBarIsBottom;

            // get content and tab container index
            Element root = this.getElement();
            for ( int index = 0; index < root.getChildCount(); index++ )
            {
                switch ( DOM.getChild( root, index )
                            .getClassName() )
                {
                    case CONTENT:
                        contentIndex = index;
                        break;
                    case TAB_CONTAINER:
                        tabContainerIndex = index;
                        break;
                    default:
                        break;
                }
            }

            // move tab container to new location
            if ( 0 <= contentIndex && 0 <= tabContainerIndex )
            {
                if ( tabBarIsBottom )
                {
                    DOM.insertChild( root, DOM.getChild( root, tabContainerIndex ),
                                     Math.min( contentIndex + 1, root.getChildCount() - 1 ) );
                }
                else
                {
                    DOM.insertChild( root, DOM.getChild( root, tabContainerIndex ), contentIndex );
                }
            }
        }
    }

}
