/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dtabs.client;

import org.dussan.vaadin.dtabs.DTabs;

import com.vaadin.client.communication.StateChangeEvent;
import com.vaadin.client.ui.tabsheet.TabsheetConnector;
import com.vaadin.shared.ui.Connect;

@Connect( DTabs.class )
public class TabsConnector
    extends TabsheetConnector
{

    private static final long serialVersionUID = -5835057962150067653L;

    public TabsConnector()
    {
        // Do nothing
    }

    @Override
    public TabsState getState()
    {
        return (TabsState) super.getState();
    }

    @Override
    public TabsWidget getWidget()
    {
        return (TabsWidget) super.getWidget();
    }

    @Override
    public void onStateChanged( StateChangeEvent stateChangeEvent )
    {
        getWidget().setTabBarBottom( getState().isTabBarBottom() );
        super.onStateChanged( stateChangeEvent );
    }

}
