/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dtabs;

import org.junit.Assert;
import org.junit.Test;

public class DTabsTest
{

    @Test
    public void setProperties()
    {
        DTabs tabs = new DTabs();
        tabs.setProperties( DTabsProperty.BOTTOM_TABBAR, DTabsProperty.CENTERED_TABS, DTabsProperty.COMPACTED_TABBAR,
                            DTabsProperty.EQUAL_WIDTH_TABS, DTabsProperty.FRAMED_TABS, DTabsProperty.ICONS_ON_TOP,
                            DTabsProperty.ONLY_SELECTED_TAB_IS_CLOSABLE, DTabsProperty.RIGHT_ALIGNED_TABS,
                            DTabsProperty.PADDED_TABBAR );

        Assert.assertTrue( tabs.isPropertyEnabled( DTabsProperty.BOTTOM_TABBAR ) );
        Assert.assertTrue( tabs.isPropertyEnabled( DTabsProperty.CENTERED_TABS ) );
        Assert.assertTrue( tabs.isPropertyEnabled( DTabsProperty.COMPACTED_TABBAR ) );
        Assert.assertTrue( tabs.isPropertyEnabled( DTabsProperty.EQUAL_WIDTH_TABS ) );
        Assert.assertTrue( tabs.isPropertyEnabled( DTabsProperty.FRAMED_TABS ) );
        Assert.assertTrue( tabs.isPropertyEnabled( DTabsProperty.ICONS_ON_TOP ) );
        Assert.assertTrue( tabs.isPropertyEnabled( DTabsProperty.ONLY_SELECTED_TAB_IS_CLOSABLE ) );
        Assert.assertTrue( tabs.isPropertyEnabled( DTabsProperty.RIGHT_ALIGNED_TABS ) );
        Assert.assertTrue( tabs.isPropertyEnabled( DTabsProperty.PADDED_TABBAR ) );

        Assert.assertTrue( tabs.getStyleName()
                               .contains( DTabsProperty.BOTTOM_TABBAR.toString() ) );
        Assert.assertTrue( tabs.getStyleName()
                               .contains( DTabsProperty.CENTERED_TABS.toString() ) );
        Assert.assertTrue( tabs.getStyleName()
                               .contains( DTabsProperty.COMPACTED_TABBAR.toString() ) );
        Assert.assertTrue( tabs.getStyleName()
                               .contains( DTabsProperty.EQUAL_WIDTH_TABS.toString() ) );
        Assert.assertTrue( tabs.getStyleName()
                               .contains( DTabsProperty.FRAMED_TABS.toString() ) );
        Assert.assertTrue( tabs.getStyleName()
                               .contains( DTabsProperty.ICONS_ON_TOP.toString() ) );
        Assert.assertTrue( tabs.getStyleName()
                               .contains( DTabsProperty.ONLY_SELECTED_TAB_IS_CLOSABLE.toString() ) );
        Assert.assertTrue( tabs.getStyleName()
                               .contains( DTabsProperty.RIGHT_ALIGNED_TABS.toString() ) );
        Assert.assertTrue( tabs.getStyleName()
                               .contains( DTabsProperty.PADDED_TABBAR.toString() ) );
    }

    @Test
    public void removeProperties()
    {
        DTabs tabs = new DTabs();
        tabs.setProperties( DTabsProperty.BOTTOM_TABBAR, DTabsProperty.CENTERED_TABS, DTabsProperty.COMPACTED_TABBAR,
                            DTabsProperty.EQUAL_WIDTH_TABS, DTabsProperty.FRAMED_TABS, DTabsProperty.ICONS_ON_TOP,
                            DTabsProperty.ONLY_SELECTED_TAB_IS_CLOSABLE, DTabsProperty.RIGHT_ALIGNED_TABS,
                            DTabsProperty.PADDED_TABBAR );
        tabs.removeProperties( DTabsProperty.BOTTOM_TABBAR, DTabsProperty.CENTERED_TABS, DTabsProperty.COMPACTED_TABBAR,
                               DTabsProperty.EQUAL_WIDTH_TABS, DTabsProperty.FRAMED_TABS, DTabsProperty.ICONS_ON_TOP,
                               DTabsProperty.ONLY_SELECTED_TAB_IS_CLOSABLE, DTabsProperty.RIGHT_ALIGNED_TABS,
                               DTabsProperty.PADDED_TABBAR );

        Assert.assertTrue( tabs.isPropertyDisabled( DTabsProperty.BOTTOM_TABBAR ) );
        Assert.assertTrue( tabs.isPropertyDisabled( DTabsProperty.CENTERED_TABS ) );
        Assert.assertTrue( tabs.isPropertyDisabled( DTabsProperty.COMPACTED_TABBAR ) );
        Assert.assertTrue( tabs.isPropertyDisabled( DTabsProperty.EQUAL_WIDTH_TABS ) );
        Assert.assertTrue( tabs.isPropertyDisabled( DTabsProperty.FRAMED_TABS ) );
        Assert.assertTrue( tabs.isPropertyDisabled( DTabsProperty.ICONS_ON_TOP ) );
        Assert.assertTrue( tabs.isPropertyDisabled( DTabsProperty.ONLY_SELECTED_TAB_IS_CLOSABLE ) );
        Assert.assertTrue( tabs.isPropertyDisabled( DTabsProperty.RIGHT_ALIGNED_TABS ) );
        Assert.assertTrue( tabs.isPropertyDisabled( DTabsProperty.PADDED_TABBAR ) );

        Assert.assertFalse( tabs.getStyleName()
                                .contains( DTabsProperty.BOTTOM_TABBAR.toString() ) );
        Assert.assertFalse( tabs.getStyleName()
                                .contains( DTabsProperty.CENTERED_TABS.toString() ) );
        Assert.assertFalse( tabs.getStyleName()
                                .contains( DTabsProperty.COMPACTED_TABBAR.toString() ) );
        Assert.assertFalse( tabs.getStyleName()
                                .contains( DTabsProperty.EQUAL_WIDTH_TABS.toString() ) );
        Assert.assertFalse( tabs.getStyleName()
                                .contains( DTabsProperty.FRAMED_TABS.toString() ) );
        Assert.assertFalse( tabs.getStyleName()
                                .contains( DTabsProperty.ICONS_ON_TOP.toString() ) );
        Assert.assertFalse( tabs.getStyleName()
                                .contains( DTabsProperty.ONLY_SELECTED_TAB_IS_CLOSABLE.toString() ) );
        Assert.assertFalse( tabs.getStyleName()
                                .contains( DTabsProperty.RIGHT_ALIGNED_TABS.toString() ) );
        Assert.assertFalse( tabs.getStyleName()
                                .contains( DTabsProperty.PADDED_TABBAR.toString() ) );
    }

    @Test
    public void testTabs()
    {
        DTabs tabs = new DTabs();

        tabs.setTabBarBottom( true );
        Assert.assertTrue( tabs.isTabBarBottom() );

        tabs.setCenteredTabs( true );
        Assert.assertTrue( tabs.isTabsCentered() );
        Assert.assertTrue( tabs.getStyleName()
                               .contains( DTabsProperty.CENTERED_TABS.toString() ) );

        tabs.setCenteredTabs( false );
        Assert.assertFalse( tabs.isTabsCentered() );
        Assert.assertFalse( tabs.getStyleName()
                                .contains( DTabsProperty.CENTERED_TABS.toString() ) );

        tabs.setCompactedTabBar( true );
        Assert.assertTrue( tabs.isTabBarCompacted() );
        Assert.assertTrue( tabs.getStyleName()
                               .contains( DTabsProperty.COMPACTED_TABBAR.toString() ) );

        tabs.setCompactedTabBar( false );
        Assert.assertFalse( tabs.isTabBarCompacted() );
        Assert.assertFalse( tabs.getStyleName()
                                .contains( DTabsProperty.COMPACTED_TABBAR.toString() ) );

        tabs.setEqualWidthTabs( true );
        Assert.assertTrue( tabs.isTabsEqualWidth() );
        Assert.assertTrue( tabs.getStyleName()
                               .contains( DTabsProperty.EQUAL_WIDTH_TABS.toString() ) );

        tabs.setEqualWidthTabs( false );
        Assert.assertFalse( tabs.isTabsEqualWidth() );
        Assert.assertFalse( tabs.getStyleName()
                                .contains( DTabsProperty.EQUAL_WIDTH_TABS.toString() ) );

        tabs.setFramedTabs( true );
        Assert.assertTrue( tabs.isTabsFramed() );
        Assert.assertTrue( tabs.getStyleName()
                               .contains( DTabsProperty.FRAMED_TABS.toString() ) );

        tabs.setFramedTabs( false );
        Assert.assertFalse( tabs.isTabsFramed() );
        Assert.assertFalse( tabs.getStyleName()
                                .contains( DTabsProperty.FRAMED_TABS.toString() ) );

        tabs.setIconsOnTop( true );
        Assert.assertTrue( tabs.isIconsOnTop() );
        Assert.assertTrue( tabs.getStyleName()
                               .contains( DTabsProperty.ICONS_ON_TOP.toString() ) );

        tabs.setIconsOnTop( false );
        Assert.assertFalse( tabs.isIconsOnTop() );
        Assert.assertFalse( tabs.getStyleName()
                                .contains( DTabsProperty.ICONS_ON_TOP.toString() ) );

        tabs.setOnlySelectedTabClosable( true );
        Assert.assertTrue( tabs.isOnlySelectedTabClosable() );
        Assert.assertTrue( tabs.getStyleName()
                               .contains( DTabsProperty.ONLY_SELECTED_TAB_IS_CLOSABLE.toString() ) );

        tabs.setOnlySelectedTabClosable( false );
        Assert.assertFalse( tabs.isOnlySelectedTabClosable() );
        Assert.assertFalse( tabs.getStyleName()
                                .contains( DTabsProperty.ONLY_SELECTED_TAB_IS_CLOSABLE.toString() ) );

        tabs.setPaddedTabBar( true );
        Assert.assertTrue( tabs.isTabBarPadded() );
        Assert.assertTrue( tabs.getStyleName()
                               .contains( DTabsProperty.PADDED_TABBAR.toString() ) );

        tabs.setPaddedTabBar( false );
        Assert.assertFalse( tabs.isTabBarPadded() );
        Assert.assertFalse( tabs.getStyleName()
                                .contains( DTabsProperty.PADDED_TABBAR.toString() ) );

        tabs.setRightAlignedTabs( true );
        Assert.assertTrue( tabs.isTabsRightAligned() );
        Assert.assertTrue( tabs.getStyleName()
                               .contains( DTabsProperty.RIGHT_ALIGNED_TABS.toString() ) );

        tabs.setRightAlignedTabs( false );
        Assert.assertFalse( tabs.isTabsRightAligned() );
        Assert.assertFalse( tabs.getStyleName()
                                .contains( DTabsProperty.RIGHT_ALIGNED_TABS.toString() ) );
    }

}
